class Hat_SeqAct_HideBone extends SequenceAction;

/* This node allows you to hide specific bones of a skeletal mesh.
Please note that any children of the bone being hid will also be affected.
UltraBoo 2024
*/

var() Name BoneName<ToolTip=Name of the bone to be hidden>;

static event int GetObjClassVersion()
{
	return Super.GetObjClassVersion()+1;
}

defaultproperties
{
	ObjName="Hide Skeletal Bone"
	ObjCategory="Actor"
    bCallHandler = false;
	InputLinks(0)=(LinkDesc="Hide")
	InputLinks(1)=(LinkDesc="Unhide")
}

event Activated()
{
	local Object t;
	
	foreach Targets(t)
	{
		if (Hat_NPC(t) != None)
			HideBone(Hat_NPC(t).SkeletalMeshComponent, InputLinks[0].bHasImpulse);
			
		else if (SkeletalMeshActor(t) != None)
			HideBone(SkeletalMeshActor(t).SkeletalMeshComponent, InputLinks[0].bHasImpulse);
		
		else if (Pawn(t) != None)
			HideBone(Pawn(t).Mesh, InputLinks[0].bHasImpulse);

        else if (Controller(t).Pawn != None)
            HideBone(Controller(t).Pawn.Mesh, InputLinks[0].bHasImpulse);
	}
}

function HideBone(SkeletalMeshComponent c, bool IsHide)
{
    if(IsHide) c.HideBoneByName(BoneName, c.EPhysBodyOp.PBO_Disable);
    else c.UnHideBoneByName(BoneName);
}