/**
 * me (CatCube) :D 
 *
 * Hud element that draws the text inputted on screen in the same style as the race hud, using a string instead of a texture.
 */

Class Cat_HUDElement_ScreenText extends Hat_HUDElement;

var string MyString;
var float Progress;
var float TotalTime;
var float totalscale;

defaultproperties
{
	Progress = -1;
	TotalTime = 1.5;
	totalscale = 0.5;
}

function OnOpenHUD(HUD H, optional String command)
{
	Progress = 0;
	MyString = command;
}

function bool Tick(HUD H, float d)
{
	if (!Super.Tick(H, d)) return false;
	
	Progress += d;
	if (Progress >= TotalTime)
	{
		CloseHUD(H);
		return false;
	}
	
	return true;
}
function bool Render(HUD H)
{
	local float minsize, startscale, endscale, size, per, persmooth, alpha;
    
    if (!Super.Render(H)) return false;
    if (Hat_HUD(H) != None && Hat_HUD(H).bForceHideHud) return false;
	
	minsize = FMin(H.Canvas.ClipX, H.Canvas.ClipY);
	startscale = minsize*0.01;
	endscale = minsize*totalscale;
	
	per = Progress/TotalTime;
	persmooth = 1.0-((1.0-per)**3);
	size = (startscale + (endscale-startscale)*persmooth)*0.007;
	
	alpha = 255*(1.0 - FMax(per-0.6,0)/(1.0-0.6));
	
	H.Canvas.SetDrawColor(255, 255, 255, alpha);
	
	H.Canvas.Font = class'Hat_FontInfo'.static.GetDefaultFont(MyString);
	DrawBorderedText(H.Canvas, MyString, H.Canvas.ClipX * 0.5, H.Canvas.ClipY * 0.5, size, true, TextAlign_Center); //0.005

    return true;
}