/**
 * Copyright 1998-2014 Epic Games, Inc. All Rights Reserved.
 */
class Ink_SeqCond_IsDisguised extends SequenceCondition;

var() Array<string> PlayableAlternatives;
var() class<Hat_Ability_Trigger> RequiredHat;
var() class<Hat_CosmeticItemQualityInfo> RequiredCosmetic;
var() class<Hat_Collectible_Skin> RequiredSkin;

var Array<Actor> Targets;

event Activated()
{
	local int i;
	local bool IsDisguised;
	local Pawn p;

	IsDisguised = false;
    
	for (i = 0; i < Targets.Length; i++)
	{
		if (Pawn(Targets[i]) != None)
			p = Pawn(Targets[i]);
		else if (Controller(Targets[i]) != None)
			p = Controller(Targets[i]).Pawn;
		else
		{
			p = None;
			continue;
		}

		//Print(String(p.class));
		if (IsPlayerDisguised(Hat_Player(p), PlayableAlternatives, RequiredHat, RequiredCosmetic, RequiredSkin))
		{
			IsDisguised = true;
			break;
		}
	}

    OutputLinks[IsDisguised ? 0 : 1].bHasImpulse = true;
}

static function bool IsPlayerDisguised(Hat_Player ply,
	Array<string> InPlayableAlternatives,
	class<Hat_Ability_Trigger> InRequiredHat,
	class<Hat_CosmeticItemQualityInfo> InRequiredCosmetic,
	class<Hat_Collectible_Skin> InRequiredSkin)
{
	local Hat_Loadout loadout;
	local int i;

	if (ply == None) return false;
	if (Hat_PlayerController(ply.Controller) == None) return false;

	//Several catlike playables may confuse the enemy!
	for (i = 0; i < InPlayableAlternatives.Length; i++)
	{
		if (ply.IsA(Name(InPlayableAlternatives[i])))
			return true;
	}

	if (InPlayableAlternatives.Length > 0 && InRequiredSkin == None && InRequiredHat == None && InRequiredCosmetic == None) return false; //If all aren't set, we're requiring playables.
	
	if (InRequiredSkin != None)
	{
		loadout = Hat_PlayerController(ply.Controller).GetLoadout();
		if (loadout == None) return false;
		if (loadout.MyLoadout.Skin == None || loadout.MyLoadout.Skin.BackpackClass != InRequiredSkin) return false;
	}

	if (InRequiredHat != None)
	{
		if (Hat_InventoryManager(ply.InvManager) == None) return false;
		if (Hat_InventoryManager(ply.InvManager).Hat == None) return false;
		if (Hat_InventoryManager(ply.InvManager).Hat.class != InRequiredHat) return false;

		if (InRequiredCosmetic != None)
		{
			if (Hat_InventoryManager(ply.InvManager).Hat.MyItemQualityInfo != InRequiredCosmetic) 
				return false;
		}
	}

	return true;
}

static function Print(string s)
{
    class'WorldInfo'.static.GetWorldInfo().Game.Broadcast(class'WorldInfo'.static.GetWorldInfo(), s);
}

defaultproperties
{
	ObjName="Is Player Disguised (Template)"
	ObjCategory="Player"
	OutputLinks(0)=(LinkDesc="True")
	OutputLinks(1)=(LinkDesc="False")
	VariableLinks(0)=(ExpectedType=class'SeqVar_Object',LinkDesc="Targets",PropertyName=Targets)
	
	//Setup for cat disguises!
	PlayableAlternatives.Add("Mod_Player_PlayableEmpress")
	PlayableAlternatives.Add("Kido_Player_StrayPlayer")
	PlayableAlternatives.Add("Kat_Player_Elsie")
	PlayableAlternatives.Add("ben_SuperBell_Player_CateKid")
	PlayableAlternatives.Add("Persona_Player_Morgana")
	PlayableAlternatives.Add("Sal_Player_LazyPaw")
	PlayableAlternatives.Add("Kido_Player_CatVac")

	RequiredHat = class'Hat_Ability_Chemical';
	RequiredCosmetic = class'Hat_CosmeticItemQualityInfo_Chemical_NyakuzaCatEars';
	RequiredSkin = class'Hat_Collectible_Skin_Nyakuza';
}
