class Ink_GameMod_ModRemixes_RENAME extends GameMod
    config(Mods);

var() Array<class<Hat_Collectible_Remix>> RemixesToGive;

defaultproperties
{
    RemixesToGive.Add(class'Ink_Collectible_ModRemix_Template')
}

event OnModLoaded() 
{
	HookActorSpawn(class'Hat_Player', 'Hat_Player');
	GiveItem(true);
	SetTimer(0.01, false, NameOf(EditDefaults));
}

event OnModUnloaded() 
{
	GiveItem(false);
	ClearTimer(NameOf(EditDefaults));
}

function GiveItem(bool b)
{
	local Hat_Loadout loadout;
	local int i;

	loadout = Hat_PlayerController(GetALocalPlayerController()).GetLoadout();
	if (loadout == None) return;

	for (i = 0; i < RemixesToGive.Length; i++)
	{
		if (b)
			loadout.AddBackpack(class'Hat_Loadout'.static.MakeLoadoutItem(RemixesToGive[i]), false);
		else
			loadout.RemoveBackpack(class'Hat_Loadout'.static.MakeLoadoutItem(RemixesToGive[i]));
	}
}

event OnHookedActorSpawn(Object NewActor, Name Identifier)
{
	if (Identifier == 'Hat_Player') 
		GiveItem(true);
}

function EditDefaults()
{
    local class<Ink_Collectible_ModRemix_Base> ModClass;
    local class<Hat_Collectible_Remix> Remix;

    foreach RemixesToGive(Remix)
    {
        ModClass = class<Ink_Collectible_ModRemix_Base>(Remix);
        if (ModClass == None) continue; //Not a mod remix.
        ModClass.static.UpdateTargetCues();
    }
}

static final function Print(const string msg)
{
    local WorldInfo wi;
    wi = class'WorldInfo'.static.GetWorldInfo();
	
    if (wi != None)
    {
        if (wi.GetALocalPlayerController() != None)
            wi.GetALocalPlayerController().TeamMessage(None, msg, 'Event', 6);
        else
            wi.Game.Broadcast(wi, msg);
    }
}