/**
 * Custom SequenceAction to apply a camera filter to target player(s).
 *
 *
 * Janky code by Starblaster64
 */
class sb64_SeqAct_SetCameraFilter extends SequenceAction;

var() class<Hat_Collectible_CameraFilter> FilterClass<Tooltip=Camera filter class to apply to player(s).>;
var() float FadeInTime<Tooltip=Time filter effects will take to fade in when applied. Only relevant to LUT filters.>;
var() float FadeOutTime<Tooltip=Time filter effects will take to fade out when removed. Only relevant to LUT filters.>;

var() bool bForceEnableDoF<Tooltip=MatEffect filters disable DoF by default, enable this to force it on. (May look weird)>;
var() float DoFOffset<Tooltip=Sets DoF FocusInnerRadius>;
var() float RandValueOverride<Tooltip=Certain MatEffect filters use a random value between 0-1 to determine color/etc., use this to force a certain value.>;

var() Name PostProcessMaterialEffectName<Tooltip=ADVANCED - Use only if you know what you are doing!!!>;

//PopArt specific overrides.
var(PopArt) float PopArtEffect<Tooltip=Manual value override. Only affects PopArt filter.>;
var(PopArt) float PopArtRotation<Tooltip=Manual value override. Only affects PopArt filter.>;
var(PopArt) float PopArtScale<Tooltip=Manual value override. Only affects PopArt filter.>;
var(PopArt) float PopArtPalette1<Tooltip=Manual value override. Only affects PopArt filter.>;
var(PopArt) float PopArtPalette2<Tooltip=Manual value override. Only affects PopArt filter.>;
var(PopArt) float PopArtPalette3<Tooltip=Manual value override. Only affects PopArt filter.>;
var(PopArt) float PopArtPalette4<Tooltip=Manual value override. Only affects PopArt filter.>;

/**
 * Return the version number for this class.  Child classes should increment this method by calling Super then adding
 * a individual class version to the result.  When a class is first created, the number should be 0; each time one of the
 * link arrays is modified (VariableLinks, OutputLinks, InputLinks, etc.), the number that is added to the result of
 * Super.GetObjClassVersion() should be incremented by 1.
 *
 * @return	the version number for this specific class.
 */
static event int GetObjClassVersion()
{
	return Super.GetObjClassVersion() + 0;
}

defaultproperties
{
	ObjName="Set Player Camera Filter"
	ObjCategory="Visuals"
    bCallHandler=false
	
	InputLinks(0)=(LinkDesc="Apply")
	InputLinks(1)=(LinkDesc="Reset")
	
	PostProcessMaterialEffectName = "CameraFilterMaterialEffect"
	
	DoFOffset = 5800
	RandValueOverride = -1
	
	PopArtEffect	= -1
	PopArtRotation	= -1
	PopArtScale		= -1
	PopArtPalette1	= -1
	PopArtPalette2	= -1
	PopArtPalette3	= -1
	PopArtPalette4	= -1
}

event Activated()
{
	local Object t;
	local bool bReset;
	
	bReset = InputLinks[1].bHasImpulse || FilterClass == None;
	
	foreach Targets(t)
	{
		if (Pawn(t) != None)
		{
			if (PlayerController(Pawn(t).Controller) == None) continue;
			SetCameraFilter(PlayerController(Pawn(t).Controller), bReset);
			continue;
		}
		if (PlayerController(t) != None)
		{
			SetCameraFilter(PlayerController(t), bReset);
			continue;
		}
	}
}

//Adapted from Hat_HUDElementInventoryCamera2018.Items->UpdatePostProcess()
function SetCameraFilter(PlayerController pc, optional bool bRemove)
{
	local LocalPlayer lp;
	local bool LocalEnableDoF;
	local PostProcessSettings set;
	local MaterialEffect MaterialEffect;
	local MaterialInstance MatEffectMaterial, CurrentMatEffectMaterial;
	
	lp = LocalPlayer(pc.Player);
	LocalEnableDoF = true;
	
	set.bEnableDOF = LocalEnableDoF;
	set.bOverride_DOF_InterpolationDuration = true;
	set.bOverride_Scene_InterpolationDuration = true;
	set.bOverride_RimShader_InterpolationDuration = true;
	set.bOverride_MotionBlur_InterpolationDuration = true;
	
	set.DOF_InterpolationDuration = 0;
	set.MotionBlur_InterpolationDuration = 0;
	set.RimShader_InterpolationDuration = 0;
	set.Scene_InterpolationDuration = bRemove ? FadeOutTime : FadeInTime;
	
	if (FilterClass != None && FilterClass.default.GradientLUT != None)
	{
		set.bOverride_Scene_ColorGradingLUT = true;
		set.ColorGrading_LookupTable = FilterClass.default.GradientLUT;
	}
	else
	{
		set.bOverride_Scene_ColorGradingLUT = false;
		set.bOverride_Scene_HighLights = false;
		set.bOverride_Scene_MidTones = false;
		set.bOverride_Scene_Shadows = false;
	}
	
	if (!bForceEnableDoF && FilterClass != None && FilterClass.default.DisableDepthOfField)
		LocalEnableDoF = false;

	MaterialEffect = MaterialEffect(lp.PlayerPostProcess.FindPostProcessEffect(PostProcessMaterialEffectName));
	if (MaterialEffect != None)
	{
		MaterialEffect.bShowInGame = !bRemove && FilterClass != None && FilterClass.default.MaterialEffect != None;
		if (MaterialEffect.bShowInGame)
		{
			CurrentMatEffectMaterial = MaterialInstance(MaterialEffect.GetMaterial(true));
			if (CurrentMatEffectMaterial == None || CurrentMatEffectMaterial.Parent != FilterClass.default.MaterialEffect)
			{
				MatEffectMaterial = new class'MaterialInstanceConstant';
				MatEffectMaterial.SetParent(FilterClass.default.MaterialEffect);
				MatEffectMaterial.SetScalarParameterValue('DOFOffset', DoFOffset);
				MatEffectMaterial.SetScalarParameterValue('Rand', RandValueOverride >= 0 ? RandValueOverride : RandRange(0,1));
				MaterialEffect.SetMaterial(MatEffectMaterial);
			}
		}
		else
		{
			MaterialEffect.SetMaterial(None);
			MatEffectMaterial = None;
		}
	}
	
	set.bOverride_EnableDOF = true;
	set.bEnableDOF = LocalEnableDoF;
	
	// set.bOverride_DOF_BlurKernelSize = true;
	// set.DOF_BlurKernelSize = 4;
	
	set.bOverride_DOF_FocusInnerRadius = true;
	set.DOF_FocusInnerRadius = DoFOffset;
	
	lp.ClearPostProcessSettingsOverride(FadeOutTime);
	if (!bRemove)
	{
		lp.OverridePostProcessSettings(set, FadeInTime);
		SetFilterSpecificParameters(MatEffectMaterial);
	}
}

function SetFilterSpecificParameters(MaterialInstance MatInst)
{
	if (MatInst == None) return;
	if (class<Hat_Collectible_CameraFilter_PopArt>(FilterClass) != None)
	{
		MatInst.SetScalarParameterValue('PopArt_RandomEffect'  , PopArtEffect >= 0 ? PopArtEffect : RandRange(0,1));
		MatInst.SetScalarParameterValue('PopArt_RandomRotation', PopArtRotation >= 0 ? PopArtEffect : RandRange(0,1));
		MatInst.SetScalarParameterValue('PopArt_RandomScale'   , PopArtScale >= 0 ? PopArtEffect : RandRange(0,1));

		MatInst.SetScalarParameterValue('PopArt_RandomPalette1', PopArtPalette1 >= 0 ? PopArtEffect : RandRange(0,1));
		MatInst.SetScalarParameterValue('PopArt_RandomPalette2', PopArtPalette2 >= 0 ? PopArtEffect : RandRange(0,1));
		MatInst.SetScalarParameterValue('PopArt_RandomPalette3', PopArtPalette3 >= 0 ? PopArtEffect : RandRange(0,1));
		MatInst.SetScalarParameterValue('PopArt_RandomPalette4', PopArtPalette4 >= 0 ? PopArtEffect : RandRange(0,1));
	}
}