class SS_StatusEffect_FreezingFog extends Hat_StatusEffect;

var SoundCue ColdSound;
var SoundCue FirePowerRemoved;

const FreezingDelay = 0.75f;
const FirstDamageDelay = 1.25f;
const DamageDelay = 2.0f;
const VolumeExitDelay = 0.75;

var float FreezingTimer;
var float FirstDamageTimer;
var float DamageTimer;

// var bool IsFrozen;

var bool LeftVolume;
var float VolumeExitTimer;

defaultproperties
{
    Duration = -1;
	
	ColdSound = SoundCue'HatinTime_SFX_Player5.SoundCues.player_cold_overlay';
	FirePowerRemoved = SoundCue'hatintime_sfx_deathwish.SoundCues.Overheating_Water_CoolDown';
}

function OnAdded(Actor a)
{
	Super.OnAdded(a);
	FreezingTimer = FreezingDelay;
	FirstDamageTimer = FirstDamageDelay;
	DamageTimer = DamageDelay;
	VolumeExitTimer = VolumeExitDelay;
	

}

simulated function OnRemoved(Actor a)
{
	
	if(FreezingTimer <= 0)
		RemoveFreeze();
	
	FirstDamageTimer = 1.0f;
    DamageTimer = 1.0f;
	Hat_Player(a).RemoveStatusEffect(class'SS_StatusEffect_SlowingCold');
	
	RemovePlayer(a);
}

function RemovePlayer(Actor a)
{
	Super.OnRemoved(a);
}

function bool Update(float d)
{

	local Hat_Player plyr;
	
	plyr = Hat_Player(Owner);
	
    if (!Super.Update(d) || plyr == None) return false;	
	
	if(LeftVolume)
		VolumeExitTimer -= d;
	else if(FreezingTimer >= 0)
		FreezingTimer -= d;
	else if(FirstDamageTimer >= 0)
		FirstDamageTimer -= d;
	else
		DamageTimer -= d;
	
	if(VolumeExitTimer <= 0)
		plyr.RemoveStatusEffect(class'SS_StatusEffect_FreezingFog');
	
	if(FreezingTimer <= 0 && FirstDamageTimer == 1.25f && DamageTimer == 2.0f){
		if(plyr.HasStatusEffect(class'SS_StatusEffect_FirePower')){
		
			RemoveFirePower();
			FreezingTimer = 1.0f;
			
		}
		else if(plyr.HasStatusEffect(class'SS_StatusEffect_IcePower'))
			FreezingTimer = 0.33f;
		else
			FreezePlayer();
	}
	
	if(FirstDamageTimer <= 0 && DamageTimer == 2.0f)
		DamageFreeze();
		
	if(DamageTimer <= 0){
		DamageFreeze();
		DamageTimer = 2.0f;
		
	}
	
	if(FreezingTimer <= 0 && (plyr.HasStatusEffect(class'SS_StatusEffect_IcePower') || plyr.HasStatusEffect(class'SS_StatusEffect_FirePower')))
		ResetartFog();
		
	return true;
}

function FreezePlayer()
{
	
	local Hat_PlayerController pc;
	local Hat_Player plyr;
	
	pc = Hat_PlayerController(Owner);
	
	if (pc == None)
	{
		plyr = Hat_Player(Owner);
		pc = Hat_PlayerController(plyr.Controller);
	}
	else
	{
		plyr = Hat_Player(pc.Pawn);
	}
	
	Hat_HUD(pc.MyHUD).DoFreezingEffect(true);
	plyr.SetTransitionEffect('ColdWater', 0, 1, 1);
	plyr.PlaySound(ColdSound);
	plyr.RemoveStatusEffect(class'Hat_StatusEffect_Wet');	
	plyr.GiveStatusEffect(class'SS_StatusEffect_SlowingCold');

}



function RemoveFreeze()
{

	local Hat_PlayerController pc;
	local Hat_Player plyr;
	
	pc = Hat_PlayerController(Owner);
	
	if (pc == None)
	{
		plyr = Hat_Player(Owner);
		pc = Hat_PlayerController(plyr.Controller);
	}
	else
	{
		plyr = Hat_Player(pc.Pawn);
	}
	
	Hat_HUD(pc.MyHUD).DoFreezingEffect(false);
	plyr.SetTransitionEffect('ColdWater', 1, 0, 0.75);

}

function ResetartFog()
{
	local Hat_PlayerController pc;
	local Hat_Player plyr;
	
	FreezingTimer = 0.75f;
	FirstDamageTimer = 1.25f;
	DamageTimer = 2.0f;
	
	pc = Hat_PlayerController(Owner);
	
	if (pc == None)
	{
		plyr = Hat_Player(Owner);
		pc = Hat_PlayerController(plyr.Controller);
	}
	else
	{
		plyr = Hat_Player(pc.Pawn);
	}
	
	Hat_HUD(pc.MyHUD).DoFreezingEffect(false);
	if(plyr.HasStatusEffect(class'SS_StatusEffect_IcePower'))
		return;
	else
		plyr.SetTransitionEffect('ColdWater', 1, 0, 0.25);
}

function RemoveFirePower()
{
	Hat_Player(Owner).RemoveStatusEffect(class'SS_StatusEffect_FirePower');
	Hat_Player(Owner).PlaySound(FirePowerRemoved);
	Hat_Player(Owner).GiveStatusEffect(class'Hat_StatusEffect_Wet');
}

function DamageFreeze()
{
	Hat_Player(Owner).TakeDamage(1.0, None, Hat_Player(Owner).Location, vect(0,0,0), class'Hat_DamageType_WorldNoAnim');
}