/**
 *
 * Copyright 2012-2015 Gears for Breakfast ApS. All Rights Reserved.
 */

class SS_Hazard_Lavafall extends Hat_DynamicStaticActor
    placeable;
	
var class<Hat_DamageType> LavaDamageType;
	
    
defaultproperties
{
    bWorldGeometry=false
	bNoDelete=True
	bMovable=False
	bGameRelevant=True
	
	Begin Object Name=StaticMeshComponent0
		StaticMesh=StaticMesh'HatInTime_Levels_Alps_H2.models.alp_lava_fall_01'
		bUsePrecomputedShadows=true
		CollideActors=true
		BlockActors=false
		CanClimbInfinitely=true;
	End Object
	
	bCollideComplex=true;
	bCollideActors=true
	bBlockActors=false
	LavaDamageType = class'Hat_DamageType_Lava';
	ScriptShouldIgnoreBlockingBy = true;
}

simulated event Touch( Actor Other, PrimitiveComponent OtherComp, vector HitLocation, vector HitNormal )
{
	if(Other == None) return;
	
	if (Other.IsA('Hat_Player') && Hat_Pawn(Other).CanTakeDamage(FALSE, self, 1))
	{
		Other.TakeDamage(1.0, None, Location, Normal(Other.Location - Location)*300 + vect(0,0,50), LavaDamageType);
	}
	Super.Touch(Other, OtherComp, HitLocation, HitNormal);
}