class mcu8_SeqAct_GetPlayerName extends SequenceAction;

defaultproperties 
{
    ObjName="GetPlayerName"
	ObjCategory="Steam"
	bCallHandler=false
    VariableLinks.Empty
}

var() string ConversationStringName<autocomment=true>;
var() string ValueOnFail<autocomment=true>; // if user is non-steam

event Activated()
{
	SetConversationString(ConversationStringName, GetMySteamNickname(), 0);
}

function string GetMySteamNickname()
{
	local OnlineSubsystem OnlineSubsystem;
	local String Nickname;
	OnlineSubsystem = class'GameEngine'.static.GetOnlineSubsystem();
	if (OnlineSubsystem == None)
		return ValueOnFail;
	Nickname = OnlineSubsystemCommonImpl(OnlineSubsystem).GetPlayerNicknameFromIndex(0);
	return Nickname;
}

function SetConversationString(string varname, string value, int lifetime)
{
	local Worldinfo w;
	local Hat_GameManager g;
	
	w = GetWorldInfo();
	if (w != None && w.game != None)
	{
		g = Hat_GameManager(w.game);
		if (g != None)
		{
			g.SetConversationString(varname, value, lifetime);
		}
	}
}
