class Ban_SeqAct_DoFullLightEnvUpdate extends SequenceAction;

event Activated()
{
	local int i;
	local Actor Target;
	local DynamicLightEnvironmentComponent LE;
	
	//go through all targets (support multiple targets)
	for (i=0; i<Targets.Length; i++)
	{
		Target = Actor(Targets[i]);
		if (Target == None) continue;
		
		//go through all of the light environments this actor owns (usually one)
		foreach Target.AllOwnedComponents(class'DynamicLightEnvironmentComponent', LE)
		{
			//from DynamicLightEnvironmentComponent: light environment does a full update of its surrounding lights
			LE.ResetEnvironment();
			//from ActorComponent: without this, the actor will still have the old lighting on it for one frame
			LE.ForceUpdate(false);		
		}
	}
}

defaultproperties
{
	ObjName="Full Light Environment Update"
	ObjCategory="Actor"
	bCallHandler=false
}
