class SS_SequenceAction_ToggleRain extends SequenceAction;
 
var Actor Player;

event Activated()
{	
	local Hat_Player plyr, plyVol;
	local Hat_PlayerController pc;
    
	plyVol = Hat_Player(Player);

	if(plyVol != None && plyVol.IsA('Hat_Player'))
	{
		plyr = plyVol;
	}
	else
	{
		pc = Hat_PlayerController(Player);
		plyr = Hat_Player(pc.Pawn);
	}

    if(!plyr.IsA('Hat_Player')) return;
    
	if(InputLinks[0].bHasImpulse)
		pc.StartRainManager();

	if(InputLinks[1].bHasImpulse && pc.RainManager != None)
	{
		Hat_RainManager(pc.RainManager).CleanUp();
		pc.RainManager = None;
	}
	OutputLinks[0].bHasImpulse = true;
}
 
final function Print(const string msg)
{
    local WorldInfo wi;
    
	wi = class'WorldInfo'.static.GetWorldInfo();
    if (wi != None)
    {
        if (wi.GetALocalPlayerController() != None)
            wi.GetALocalPlayerController().TeamMessage(None, msg, 'Event', 6);
        else
            wi.Game.Broadcast(wi, msg);
    }
}

defaultproperties
{
	ObjName="Toggle Rain";
	ObjCategory="World";
 
	InputLinks(0)=(LinkDesc="On");
	InputLinks(1)=(LinkDesc="Off");

	OutputLinks(0)=(LinkDesc="Out");
	VariableLinks(0)=(ExpectedType=class'SeqVar_Object',LinkDesc="Player",PropertyName=Player);
	
	bAutoActivateOutputLinks = false;
}