class Cat_SeqCond_CinematicModeActive extends SequenceCondition;

var Actor Target;

event Activated()
{
	local bool IsCinematicModeActive;
	local Hat_PlayerController PC;

	PC = Hat_PlayerController(Target); // cast
	
	if (PC.bCinematicMode == true || PC.IsTalking())
	{
		IsCinematicModeActive = true;
	}

    OutputLinks[IsCinematicModeActive ? 0 : 1].bHasImpulse = true;
}

defaultproperties
{
	ObjName="Is Cinematic Mode Active"
	ObjCategory="Pawn"

	OutputLinks(0)=(LinkDesc="True")
	OutputLinks(1)=(LinkDesc="False")
	VariableLinks(0)=(ExpectedType=class'SeqVar_Object',LinkDesc="Target",PropertyName=Target,MinVars=1,MaxVars=1)
}