class Cat_SeqAct_PlayDeathWish extends SequenceAction;

/** Which DeathWish we want to load */
var() class<Hat_SnatcherContract_DeathWish> DeathWishClass;

/** Overrides the Title Card of this Death Wish with your own no matter what, if not set will use the default */
var() Texture2D TitleCardOverride;

var MaterialInterface DeathWishTitleCardMaterial;

event Activated()
{
	if (DeathWishClass == None) return;
	
	Super.Activated();
	
	StaticPlayDeathWish();
}

function StaticPlayDeathWish()
{
	local Hat_ChapterInfo ChapterInfo;
	local Hat_ChapterActInfo ActInfo;
	local PlayerController PlayerController;
	local Hat_HUD MyHUD;
	local Hat_HUDElementActTitleCard TitleCard;
	local MaterialInstanceConstant TitleCaMaterialInstance;
	local string ChapterName, ActName, MapName;
	local Texture2D TitlecardBackground, CoopIcon;
	
	local Hat_SaveGame SaveGame;
	
	ActInfo = DeathWishClass.default.ActInfo;
	ChapterInfo = ActInfo != None ? ActInfo.ChapterInfo : None;
	MapName = ActInfo != None ? ActInfo.MapName : "";
	
	SaveGame = Hat_SaveGame(`SaveManager.SaveData);
	
	`GameManager.LoadNewAct(ChapterInfo.ChapterID, ActInfo.ActID);
	
	if (class'Hat_GameManager'.default.AssistMode && DeathWishClass.default.HasEasyMode)
		DeathWishClass.static.SetDeathWishEasyMode(true);
	
	if (ActInfo != None && ActInfo == Hat_ChapterActInfo'HatinTime_ChapterInfo.AlpineSkyline.AlpineSkyline_Finale')
		class'Hat_SeqCond_IsAlpineFinale'.static.ForceEnableAlpineFinale();
	
	if (DeathWishClass.default.AllowedMaps.length > 0 && DeathWishClass.default.AllowedMaps.Find(MapName) == INDEX_NONE)
		MapName = DeathWishClass.default.AllowedMaps[0];

	if (DeathWishClass.default.StartCheckpoint > 0)
		`GameManager.SetCurrentCheckpoint(DeathWishClass.default.StartCheckpoint, false, false);

	if (DeathWishClass.default.StartAct > 0)
		`GameManager.SetCurrentAct(DeathWishClass.default.StartAct);
	
	// Open title card
	PlayerController = `GameManager.GetALocalPlayerController();
	if (PlayerController != None && PlayerController.myHUD != None)
	{
		MyHUD = Hat_HUD(PlayerController.myHUD);
		if (MyHUD != None)
		{
			ChapterName = "";
			if (DeathWishClass.static.ConsiderForDeathWishTotal())
			{
				if (DeathWishClass.default.IsCommunity)
					ChapterName = Caps(class'Hat_Localizer'.static.GetGame("levels", "Community"));
				else
					ChapterName = Caps(class'Hat_Localizer'.static.GetGame("levels", "DeathWish"));
			}

			if (DeathWishClass.default.IsCommunity)
				ActName = Caps(DeathWishClass.static.GetShortLocalizedTitle());
			else
				ActName = Caps(DeathWishClass.static.GetLocalizedTitle());
			
			
			if (TitleCardOverride != None)
			{
				TitlecardBackground = TitleCardOverride;
			}
			else
			{
				TitlecardBackground = ActInfo != None ? ActInfo.GetTitleCardBackground() : None;
			}
				
			CoopIcon = class'Hat_HUDElementActTitleCard'.default.DefaultCoopIcon[Rand(class'Hat_HUDElementActTitleCard'.default.DefaultCoopIcon.Length)];
			if (ActInfo != None && ActInfo.CoopIcon != None) CoopIcon = ActInfo.CoopIcon;
			if (ActInfo != None && ActInfo.IsBonus && TitlecardBackground == None && TitleCardOverride == None)
			{
				if (ActInfo.RequiredActID.Length > 0)
				{
					TitlecardBackground = class'Hat_HUDMenuActSelect'.default.TitleCard_TimeRiftWater;
					CoopIcon = class'Hat_HUDElementActTitleCard'.default.TimeRift_Water_CoopIcon;
				}
				else
					TitlecardBackground = class'Hat_HUDMenuActSelect'.default.TitleCard_TimeRiftCave;
			}
			
			if (DeathWishClass.static.GetTitleCard() != None && TitleCardOverride == None)
				TitlecardBackground = DeathWishClass.static.GetTitleCard();
			
			TitleCaMaterialInstance = new class'MaterialInstanceConstant';
			TitleCaMaterialInstance.SetParent(default.DeathWishTitleCardMaterial);
			TitleCaMaterialInstance.SetTextureParameterValue('Texture', TitlecardBackground);
			TitleCaMaterialInstance.SetTextureParameterValue('CoopIcon', CoopIcon);
			TitleCaMaterialInstance.SetScalarParameterValue('DeathWishOverlay', DeathWishClass.static.GetTitleCard() == None ? 1 : 0);
			TitleCaMaterialInstance.SetScalarParameterValue('CoopOverlay', `GameManager.IsCoop() ? 1 : 0);

			TitleCard = Hat_HUDElementActTitleCard(MyHUD.OpenHUD(class'Hat_HUDElementActTitleCard', MapName));
			TitleCard.SetTitleCardChapterActInfo(TitleCaMaterialInstance, ChapterName, ActName);
			TitleCard.UseActSelectLoadingMusic = true;
			TitleCard.IsDeathWish = true;
		}
	}
	
	class'Hat_SaveBitHelper'.static.AddLevelBit("IsOnActiveDeathWish", 1, `GameManager.HubMapName);
	
	// fallback level transition if title card failed
	if (TitleCard == None)
	{
		`GameManager.SoftChangeLevel(MapName);
	}
	
	SaveGame.ActiveDeathWishes.AddItem(DeathWishClass);
}

defaultproperties
{
	ObjName="Load Death Wish"
	ObjCategory="Level"
    bCallHandler=false;
	bAutoActivateOutputLinks=true;
	
	DeathWishClass = Hat_SnatcherContract_DeathWish;
	
	DeathWishTitleCardMaterial = Material'HatInTime_HUD_Titlecards.Materials.TitlecardMaterial'

	VariableLinks.Empty;
}