class Cat_SeqCond_HasSticker extends SequenceCondition;

var() class<Hat_Collectible_Sticker> StickerClass;
var() bool AllowSubclass;
var Actor Target;

event Activated()
{
	local Hat_PlayerController pc;
	local bool bHas;
	local class<Object> cClass;
    
    bHas = false;

	if (Pawn(Target) != None) Target = Pawn(Target).Controller;
	Pc = Hat_PlayerController(Target);
    if (Pc != None)
    {
		cClass = GetCollectibleClass();
		bHas = pc.GetLoadout().HasCollectible(cClass, 1, AllowSubclass);
		if (!bHas && StickerClass != None && (class'Hat_Loadout'.static.BackpackHasStickerClass(StickerClass, false) != INDEX_NONE))
			bHas = true;
    }
    OutputLinks[bHas? 0 : 1].bHasImpulse = true;
}

function class<Object> GetCollectibleClass()
{
	if (StickerClass != None && StickerClass.default.InventoryClass != None)
		return StickerClass.default.InventoryClass;
	return StickerClass;
}

defaultproperties
{
	ObjName="Has Sticker"
	ObjCategory="Save Data"

	OutputLinks(0)=(LinkDesc="True")
	OutputLinks(1)=(LinkDesc="False")
	VariableLinks(0)=(ExpectedType=class'SeqVar_Object',LinkDesc="Target",PropertyName=Target,MinVars=1,MaxVars=1)
}