// Made by SamiSha

class SS_SequenceAction_PlayVoice extends SequenceAction;
 
enum PlayVoiceSounds
{
    PVS_VoiceJump,
	PVS_VoiceWallImpact,
	PVS_VoiceAttack,
	PVS_VoiceHurt,
	PVS_VoiceHookshotCling,
	PVS_VoiceMonitorClick,
	PVS_VoiceCounting_One,
	PVS_VoiceCounting_Two,
	PVS_VoiceCounting_Three,
	PVS_VoiceCounting_Four,
	PVS_VoiceCounting_Five,
	PVS_VoiceCounting_Six,
	PVS_VoiceCounting_Seven,
	PVS_VoiceCounting_Eight,
	PVS_VoiceCounting_Nine,
	PVS_VoiceCounting_Ten,
	PVS_VoiceCollectedAll,
	PVS_VoiceFreeCitizen,
	PVS_VoiceLongFallNoDmg,
	PVS_HelpAbilityHmm,
	PVS_VoiceHatStitch_One,
	PVS_VoiceHatStitch_Two,
	PVS_VoiceMurderClueGotcha,
	PVS_VoiceHurtPant,
	PVS_VoiceNPCTease,
	PVS_VoiceVacuumSpin,
	PVS_VoiceShopItemExamine,
	PVS_VoiceShopLeave,
	PVS_VoiceChemicalExplosion,
	PVS_VoiceHatStolen,
	PVS_VoiceDivaGreet,
	PVS_VoiceTakePainting,
	PVS_VoiceBurnPainting,
	PVS_JumpSlideLandSound,
	PVS_SwimGoBelowSurfaceSound,
	PVS_SwimGoAboveSurfaceSound,
	PVS_TimedDiveJumpSound,
	PVS_DeathJingle,
	PVS_DeathJingle_DeathWish,
	PVS_EndlessPitDeathJingle,
	PVS_TakeDamageSound,
	PVS_StylishMoveSound,
	PVS_DoJumpDiveSound,
	PVS_HomingAttackStartSound,
	PVS_DoubleJumpSound,
	PVS_CrouchFootstepSound,
	PVS_HomingShootForwardSound,
	PVS_PlayerColdSound,
	PVS_VoiceTrainStartled,
	PVS_JumpSlamChargedSound,
	PVS_SneakFootstepSound
};

var() PlayVoiceSounds Sound <Tooltip=The voice you want to play, these voices are explicity set in the player's defaulproperties, this is perfect for playables with custom sounds.>;
var() float RelaxTime <Tooltip=Cooldown that refrains from playing the next PlayVoice(...) call, including this kismet!>;
var() bool IgnoreRelaxTime <Tooltip=Ignore the cooldown entirely and play the sound regardless>;
var() bool IsConversation <Tooltip=Will refrain from pitching the sound of the AudioComponent, this happens with Bow Kid aka Hat_Player_CoPartner.>;

var Actor Player;

event Activated()
{	
	local Hat_Player plyr;
	plyr = GetPlayer(Player);

	if(plyr.PlayVoice(GetPlayerVoice(plyr)) != None)
		OutputLinks[0].bHasImpulse = true;
	else
		OutputLinks[1].bHasImpulse = true;
}

function Hat_Player GetPlayer(Actor a)
{
    local Hat_Player plyr;

	plyr = Hat_Player(a);	

    return (plyr != None ? plyr : Hat_Player(Hat_PlayerController(a).Pawn));
}

// Hoh boy...
function SoundCue GetPlayerVoice(Hat_Player plyr)
{
	switch(Sound)
	{
		case PVS_VoiceJump:
			return plyr.VoiceJump;
		case PVS_VoiceWallImpact:
			return plyr.VoiceWallImpact;
		case PVS_VoiceAttack:
			return plyr.VoiceAttack;
		case PVS_VoiceHurt:
			return plyr.VoiceHurt;
		case PVS_VoiceHookshotCling:
			return plyr.VoiceHookshotCling;
		case PVS_VoiceMonitorClick:
			return plyr.VoiceMonitorClick;
		case PVS_VoiceCounting_One:
			return plyr.VoiceCounting[1];
		case PVS_VoiceCounting_Two:
			return plyr.VoiceCounting[2];
		case PVS_VoiceCounting_Three:
			return plyr.VoiceCounting[3];
		case PVS_VoiceCounting_Four:
			return plyr.VoiceCounting[4];
		case PVS_VoiceCounting_Five:
			return plyr.VoiceCounting[5];
		case PVS_VoiceCounting_Six:
			return plyr.VoiceCounting[6];
		case PVS_VoiceCounting_Seven:
			return plyr.VoiceCounting[7];
		case PVS_VoiceCounting_Eight:
			return plyr.VoiceCounting[8];
		case PVS_VoiceCounting_Nine:
			return plyr.VoiceCounting[9];
		case PVS_VoiceCounting_Ten:
			return plyr.VoiceCounting[10];
		case PVS_VoiceCollectedAll:
			return plyr.VoiceCollectedAll;
		case PVS_VoiceFreeCitizen:
			return plyr.VoiceFreeCitizen;
		case PVS_VoiceLongFallNoDmg:
			return plyr.VoiceLongFallNoDmg;
		case PVS_HelpAbilityHmm:
			return plyr.HelpAbilityHmm;
		case PVS_VoiceHatStitch_One:
			return plyr.VoiceHatStitch[0];
		case PVS_VoiceHatStitch_Two:
			return plyr.VoiceHatStitch[1];
		case PVS_VoiceMurderClueGotcha:
			return plyr.VoiceMurderClueGotcha;
		case PVS_VoiceHurtPant:
			return plyr.VoiceHurtPant;
		case PVS_VoiceNPCTease:
			return plyr.VoiceNPCTease;
		case PVS_VoiceVacuumSpin:
			return plyr.VoiceVacuumSpin;
		case PVS_VoiceShopItemExamine:
			return plyr.VoiceShopItemExamine;
		case PVS_VoiceShopLeave:
			return plyr.VoiceShopLeave;
		case PVS_VoiceChemicalExplosion:
			return plyr.VoiceChemicalExplosion;
		case PVS_VoiceHatStolen:
			return plyr.VoiceHatStolen;
		case PVS_VoiceDivaGreet:
			return plyr.VoiceDivaGreet;
		case PVS_VoiceTakePainting:
			return plyr.VoiceTakePainting;
		case PVS_VoiceBurnPainting:
			return plyr.VoiceBurnPainting;
		case PVS_JumpSlideLandSound:
			return plyr.JumpSlideLandSound;
		case PVS_SwimGoBelowSurfaceSound:
			return plyr.SwimGoBelowSurfaceSound;
		case PVS_SwimGoAboveSurfaceSound:
			return plyr.SwimGoAboveSurfaceSound;
		case PVS_TimedDiveJumpSound:
			return plyr.TimedDiveJumpSound;
		case PVS_DeathJingle:
			return plyr.DeathJingle;
		case PVS_DeathJingle_DeathWish:
			return plyr.DeathJingle_DeathWish;
		case PVS_EndlessPitDeathJingle:
			return plyr.EndlessPitDeathJingle;
		case PVS_TakeDamageSound:
			return plyr.TakeDamageSound;
		case PVS_StylishMoveSound:
			return plyr.StylishMoveSound;
		case PVS_DoJumpDiveSound:
			return plyr.DoJumpDiveSound;
		case PVS_HomingAttackStartSound:
			return plyr.HomingAttackStartSound;
		case PVS_DoubleJumpSound:
			return plyr.DoubleJumpSound;
		case PVS_CrouchFootstepSound:
			return plyr.CrouchFootstepSound;
		case PVS_HomingShootForwardSound:
			return plyr.HomingShootForwardSound;
		case PVS_PlayerColdSound:
			return plyr.PlayerColdSound;
		case PVS_VoiceTrainStartled:
			return plyr.VoiceTrainStartled;
		case PVS_JumpSlamChargedSound:
			return plyr.JumpSlamChargedSound;
		case PVS_SneakFootstepSound:
			return plyr.SneakFootstepSound;
	}
}

defaultproperties
{
	ObjName="Play Player's Voices";
	ObjCategory="Player";
 
	InputLinks(0)=(LinkDesc="Play");
		
	OutputLinks(0)=(LinkDesc="Out");
	OutputLinks(1)=(LinkDesc="Failed");
	VariableLinks(0)=(ExpectedType=class'SeqVar_Float',LinkDesc="Relax Time",PropertyName=RelaxTime);
	VariableLinks(1)=(ExpectedType=class'SeqVar_Bool',LinkDesc="Ignore Relax",PropertyName=IgnoreRelaxTime);
	VariableLinks(2)=(ExpectedType=class'SeqVar_Bool',LinkDesc="Is Conversation",PropertyName=IsConversation);
	VariableLinks(3)=(ExpectedType=class'SeqVar_Object',LinkDesc="Player",PropertyName=Player);

	bAutoActivateOutputLinks = false;
}