class Lumi_Collectible_EnergyBitRing extends Hat_Collectible
  placeable;

const TotalShrinkTime = 0.5;
//const AppearTime = 0.5;

struct Union_EnergyBitTravel
{
  var transient float TravelProgress;
  var transient Hat_Collectible_EnergyBit BitActor;
};

var() editinline ParticleSystemComponent FlashParticle<DisplayName=AmbientParticle>;
var() editinline PointLightComponent LightComp;

var() Class<Hat_Collectible_EnergyBit> EnergyBitClass;
var() MaterialInterface OverridingMats[3]; //Index 2 is the material of the diamond
var() StaticMesh OverridingMeshes[2]; //Index 1 overrides the diamond mesh in the pon
var() Color OverridingParticleColor; //Leave the RGB values of this color to zero to prevent the override
var() int EnergyBitCount;
var() float EnergyBitSpawnDelay<ClampMin=0.0>;
var() float EnergyBitTravelTime<ClampMin=0.1>;
var() float CollectShrinkSpeed<ClampMin=0.001>;

var transient Hat_Player OrgCollector;
var transient int TotalEnergyBitsSpawned;
var transient bool HasCollected;
var transient bool CanSpawnBits;
//var transient bool LastHiddenVal;
var transient float CurrentDelay;
var transient float ShrinkTime;
var transient float HidingTime;
var transient float OrgMeshScale;
var transient float OrgLightRadius;
var transient float BounceAnimOffset;
var transient Array<Union_EnergyBitTravel> SpawnedBits;

event PostBeginPlay()
{
  Super.PostBeginPlay();

  OrgMeshScale = Mesh.Scale;
  OrgLightRadius = LightComp.Radius;
  BounceAnimOffset = VSize(Location) * 0.01;
}

event bool OnCollected(Actor Collector)
{
  HasCollected = true;
  OrgCollector = Hat_Player(Collector);

  return Super.OnCollected(Collector);
}

function bool CanCollect(Actor a)
{
  if(OrgCollector != None) return false;
  if(Hat_Player(a) == None) return false;

  return Super.CanCollect(a);
}

function OnCollectedDisappear(Actor a)
{
  DoCollectEffects(a);
  FlashParticle.DeactivateSystem();
}

event Tick(float DeltaTime)
{
  local int i;
  local Union_EnergyBitTravel Temp;
  //local Vector v;

  Super.Tick(DeltaTime);
  /*
  if(LastHiddenVal != bHidden)
  {
    LastHiddenVal = bHidden;
    PerformHiddenAnim(bHidden);
  }*/

  if(!HasCollected) return;

  if(Mesh.Scale > 0.01)
  {
    Mesh.SetScale(Lerp(OrgMeshScale, 0.001, (ShrinkTime / TotalShrinkTime) ** 3));
    LightComp.Radius = Lerp(LightComp.Radius, 0.0, 0.2);
    ShrinkTime += DeltaTime * CollectShrinkSpeed;
  }
  else if(EnergyBitCount <= 0) Destroy();
  else if(!Mesh.HiddenGame) Mesh.SetHidden(true);

  for(i = 0; i < SpawnedBits.Length; i++)
  {
    if(SpawnedBits[i].TravelProgress >= EnergyBitTravelTime)
    {
      SpawnedBits[i].BitActor.OnCollected(OrgCollector);
      continue;
    }

    SpawnedBits[i].BitActor.SpawnWaitTime = 0.0;
    SpawnedBits[i].BitActor.SetLocation(VLerp(Location, OrgCollector.Location, FMax(SpawnedBits[i].TravelProgress / EnergyBitTravelTime, 0.0) ** 2));
    SpawnedBits[i].TravelProgress += DeltaTime * WorldInfo.Game.GameSpeed;
  }

  if(EnergyBitClass != None && EnergyBitCount > 0)
  {
    if(CurrentDelay < EnergyBitSpawnDelay) CurrentDelay += DeltaTime * WorldInfo.Game.GameSpeed;
    else if(CurrentDelay >= EnergyBitSpawnDelay)
    {
      if(TotalEnergyBitsSpawned >= EnergyBitCount)
      {
        if(SpawnedBits.Length == 0) Destroy();
        return;
      }

      TotalEnergyBitsSpawned++;
      CurrentDelay = 0.0;

      Temp.BitActor = Spawn(EnergyBitClass,,, Location,,, true);
      WorldInfo.MyEmitterPool.SpawnEmitter(class'Hat_Collectible_EnergyBit'.default.CollectParticle, Location, rot(0,0,0));
      Temp.BitActor.OnCollectedDelegates.AddItem(HandlePonCollection);
      if(OverridingMeshes[0] != None && StaticMeshComponent(Temp.BitActor.Mesh) != None) StaticMeshComponent(Temp.BitActor.Mesh).SetStaticMesh(OverridingMeshes[0]);
      if(OverridingMeshes[1] != None && StaticMeshComponent(Temp.BitActor.InnerItem) != None) StaticMeshComponent(Temp.BitActor.InnerItem).SetStaticMesh(OverridingMeshes[1]);
      if(OverridingMats[0] != None) Temp.BitActor.Mesh.SetMaterial(0, OverridingMats[0]);
      if(OverridingMats[1] != None) Temp.BitActor.Mesh.SetMaterial(1, OverridingMats[1]);
      if(OverridingMats[2] != None) Temp.BitActor.InnerItem.SetMaterial(2, OverridingMats[2]);
      if(OverridingParticleColor.R != 0 || OverridingParticleColor.G != 0 || OverridingParticleColor.B != 0) Temp.BitActor.CollectParticleColor = OverridingParticleColor;
      SpawnedBits.AddItem(Temp);
    }
  }
}

simulated function DoCollectEffects(Actor a)
{
	local Hat_Player ply;
  local ParticleSystemComponent Comp;

  if (CollectSound != None && ((WorldInfo != None && WorldInfo.NetMode == NM_Standalone) || Role == Role_Authority))
		PlaySound(CollectSound, false, false, false);

  ply = Hat_Player(GetPlayerFromActor(a));

  if (CollectParticle != None)
  {
    Comp = WorldInfo.MyEmitterPool.SpawnEmitter(CollectParticle, Location, Rotation);
    if(Comp != None)
    {
      Comp.SetScale(DrawScale);
      Comp.SetScale3D(DrawScale3D);
    }
  }

	if (ply != None && ForceFeedbackAmount[0] > 0)
		ply.PlayGenericForceFeedback(ForceFeedbackAmount[0], ForceFeedbackAmount[1]);
}

/*
simulated function PerformHiddenAnim(bool NewHidden)
{

}*/

function HandlePonCollection(Hat_Collectible InCollectible, Actor InCollector)
{
  local int i;

  if(InCollector == None || InCollector != OrgCollector) return;

  for(i = 0; i < SpawnedBits.Length; i++)
  {
    if(SpawnedBits[i].BitActor != InCollectible) continue;

    SpawnedBits.RemoveItem(SpawnedBits[i]);
    break;
  }
}

defaultproperties
{
  Components.Remove(Model)

  Begin Object Class=StaticMeshComponent Name=RingMesh0
    StaticMesh=StaticMesh'HatInTime_SandSails_Hab.models.sand_cake_ring'
    Materials(0)=Material'Lumi_PonRingContent.Materials.PonRingBase'
    LightEnvironment=m_hLightEnvironment
    CastShadow=false
    bAcceptsStaticDecals=false
    bAcceptsDynamicDecals=false
    Rotation=(Pitch=16384)
    Scale3D=(Z=0.5)
    CollideActors=false
    BlockActors=false
    Translation=(X=60)
  End Object
  Mesh=RingMesh0
  Components.Add(RingMesh0)

  Begin Object Class=ParticleSystemComponent Name=FlashComp0
    Template=ParticleSystem'Lumi_PonRingContent.Materials.PonRingAmbient'
    bSelectable=false
    MaxDrawDistance=5000
  End Object
  FlashParticle=FlashComp0
  Components.Add(FlashComp0)

  /*Begin Object Name=CollisionCylinder
    CollisionRadius=75
    CollisionHeight=30
    Rotation=(Pitch=16384)
  End Object*/
  Components.Remove(CollisionCylinder)

  Begin Object Class=StaticMeshComponent Name=RealCollisionCylinder
    StaticMesh=StaticMesh'HatinTime_PrimitiveShapes.TexPropCylinder'
    Rotation=(Pitch=16384)
    Scale3D=(Z=0.075)
    Scale=5.2
    CastShadow=false
    HiddenGame=true
    HiddenEditor=true
  End Object
  CollisionComponent=RealCollisionCylinder
  Components.Add(RealCollisionCylinder)

  Begin Object Class=SpriteComponent Name=EditorSprite0
    Sprite=Texture2D'HatInTime_Items.Capsules.Textures.energy_bit_billboard'
    UseBoundsForDrawDistance = false
		bAllowCullDistanceVolume = false
		bUseAsOccluder = false
    HiddenGame=true
  End Object
  Components.Add(EditorSprite0)

  Begin Object Class=PointLightComponent Name=LightComp0
    Brightness=2.0
    LightColor=(R=120,G=255,B=100)
    FalloffExponent=0.7
    ShadowFalloffExponent=4.0
    UseDirectLightMap=false
    CullDistance=6000
    LightingChannels=(BSP=true, Dynamic=true, CompositeDynamic=true)
    CastStaticShadows=false
  End Object
  LightComp=LightComp0
  Components.Add(LightComp0)

  RemoteRole=ROLE_None

  EnergyBitClass=class'Hat_Collectible_EnergyBit'
  EnergyBitCount=5
  EnergyBitSpawnDelay=0.1
  EnergyBitTravelTime=0.15
  CollectShrinkSpeed=1.2

  ContentBrowserIcon = Texture2D'HatInTime_Hud.Textures.EnergyBit'
  CollectSound=SoundCue'HatinTime_SFX_Player3.SoundCues.OrbChain1_Overlay'
  CollectParticle=ParticleSystem'Lumi_PonRingContent.Materials.PonRingCollect'
  CanBeMagnetized = false
  //BounceWhenEnabled=false
  BounceWhenEnabled=(Z=0)
  bCanBeDamaged=false
  SyncForGhostParty=false
  GhostPartyScore=0

  TickOptimize = TickOptimize_Distance
}
