class GamemodScript extends GameMod;

event OnModLoaded()
{
	HookActorSpawn(class'Hat_HUDMenu_ModLevelSelect', 'Hat_HUDMenu_ModLevelSelect');
}

event OnHookedActorSpawn(Object NewActor, Name Identifier)
{
	local Hat_HUDMenu_ModLevelSelect ModsHUD;
	local Engine E;
	local int i;
	local Hat_HUD HatHUD;
	
	if (Identifier == 'Hat_HUDMenu_ModLevelSelect')
	{
		ModsHUD = Hat_HUDMenu_ModLevelSelect(NewActor);
		if (!ModsHUD.Open || ModsHUD.ModListMode == 2)
		{
			return;
		}
		
		//find the hud on which this hud was opened
		E = class'Engine'.static.GetEngine();
		for (i = 0; i < E.GamePlayers.Length; i++)
		{
			HatHUD = Hat_HUD(E.GamePlayers[i].Actor.MyHUD);
			if (HatHUD != None && HatHUD.m_hElements.Find(ModsHUD) != INDEX_NONE)
				break;
			else
				HatHUD = None;
		}
		if (HatHUD != None) OnModHUDOpened(HatHUD, ModsHUD);
	}
}

function OnModHUDOpened(Hat_HUD H, Hat_HUDMenu_ModLevelSelect ModsHUD)
{
	local OverlayHUD Overlay;
	
	//true, because it should be placed before the mods hud in the list, to get directional inputs first (whyyy are they fired first to last when literally any other input event doesn't???)
	Overlay = OverlayHUD(H.OpenHUD(class'OverlayHUD',, true));
	if (Overlay == None) return;
	Overlay.ModsHUD = ModsHUD;
	Overlay.InitHUD(H);
}
