Class SS_Color extends Object;

enum ColorName
{
    White,
    Red,
    Green,
    Blue,
    Yellow,
    Magneta,
    Cyan,
    Aqua,
    Teal,
    Ruby,
    Grey,
    Gray,
    Light_Grey,
    Dark_Grey,
    Brown,
    Purple,
    Lavender,
    Crimson,
    Yellow_Lemon,
    Hot_Pink,
    Deep_Pink,
    Ghost_White,
    Azure_Blue,
    Neon_Blue,
    Lime,
    Violet,
    Royal_Purple,
    Orange,
    Tomato,
    Silver,
    Gold,
    Black
};

// Returns a color based on the text passed (note: hopefully not case sensitive, but it never hurts checking!)
// Returns White if it couldn't find anything.
static function Color GetColorByName(coerce optional String _name = "White")
{
    local ColorName _colorName;
    _colorName = ColorName(EnumFromString(enum'ColorName', _name));
    return GetColor(_ColorName);
}

// Returns a color based on the enum name that was passed
// Returns White as default
static function Color GetColor(optional ColorName _colorName = White)
{
    switch(_colorName)
    {
        // Uniquly named colors
        case Ruby: return MakeColor(255,87,51); // https://sami.shakkour.dev/projects/color-reader?R=255&G=87&B=51
        case Yellow_Lemon: return MakeColor(250,250,51); // https://sami.shakkour.dev/projects/color-reader?R=250&G=250&B=51
        case Ghost_White: return MakeColor(248,248,255); // https://sami.shakkour.dev/projects/color-reader?R=248&G=248&B=255
        case Azure_Blue: return MakeColor(0,128,255); // https://sami.shakkour.dev/projects/color-reader?R=0&G=128&B=255
        case Neon_Blue: return MakeColor(70,102,255); // https://sami.shakkour.dev/projects/color-reader?R=70&G=102&B=255
        case Lime: return MakeColor(191,255,0); // https://sami.shakkour.dev/projects/color-reader?R=191&G=255&B=0
        case Royal_Purple: return MakeColor(120,81,169); // https://sami.shakkour.dev/projects/color-reader?R=120&G=81&B=169
        case Hot_Pink: return MakeColor(255,105,180); // https://sami.shakkour.dev/projects/color-reader?R=255&G=105&B=180
        case Deep_Pink: return MakeColor(255,20,147); // https://sami.shakkour.dev/projects/color-reader?R=255&G=20&B=147
        case Lavender: return MakeColor(230,230,250); // https://sami.shakkour.dev/projects/color-reader?R=230&G=230&B=250
        case Violet: return MakeColor(238,130,238); // https://sami.shakkour.dev/projects/color-reader?R=238&G=130&B=238
        case Tomato: return MakeColor(255,99,71); // https://sami.shakkour.dev/projects/color-reader?R=255&G=99&B=71
        case Silver: return MakeColor(192,192,192); // https://sami.shakkour.dev/projects/color-reader?R=192&G=192&B=192
        case Gold: return MakeColor(255,215,0); // https://sami.shakkour.dev/projects/color-reader?R=255&G=215&B=0
        case Crimson: return MakeColor(220,20,60); // https://sami.shakkour.dev/projects/color-reader?R=220&G=20&B=60
        case Teal: return MakeColor(0,128,128); // https://sami.shakkour.dev/projects/color-reader?R=0&G=128&B=128
        case Light_Grey: return MakeColor(211,211,211); // https://sami.shakkour.dev/projects/color-reader?R=211&G=211&B=211
        case Dark_Grey: return MakeColor(169,169,169); // https://sami.shakkour.dev/projects/color-reader?R=169&G=169&B=169
        
        // General Colors
        case Red: return MakeColor(255,0,0); // https://sami.shakkour.dev/projects/color-reader?R=255&G=0&B=0
        case Green: return MakeColor(0,255,0); // https://sami.shakkour.dev/projects/color-reader?R=0&G=255&B=0
        case Blue: return MakeColor(0,0,255); // https://sami.shakkour.dev/projects/color-reader?R=0&G=0&B=255
        case Yellow: return MakeColor(255,255,0); // https://sami.shakkour.dev/projects/color-reader?R=255&G=255&B=0
        case Magneta: return MakeColor(255,0,255); // https://sami.shakkour.dev/projects/color-reader?R=255&G=0&B=255
        case Cyan: case Aqua: return MakeColor(0,255,255); // https://sami.shakkour.dev/projects/color-reader?R=0&G=255&B=255
        case Black: return MakeColor(0,0,0); // bro just add "local Color c;" and do nothing with it lmao

        // Basic Colors
        case Orange: return MakeColor(255,165,0); // https://sami.shakkour.dev/projects/color-reader?R=255&G=165&B=0
        case Brown: return MakeColor(165, 42, 42); // https://sami.shakkour.dev/projects/color-reader?R=165&G=42&B=42
        case Grey: case Gray: return MakeColor(128,128,128); // https://sami.shakkour.dev/projects/color-reader?R=128&G=128&B=128
        case Purple: return MakeColor(128,0,128); // https://sami.shakkour.dev/projects/color-reader?R=128&G=0&B=128

        case White: default: return MakeColor(255,255,255);
    }
    return MakeColor(255,255,255);
}