/**
 * Copyright 1998-2014 Epic Games, Inc. All Rights Reserved.
 */
class Ink_SeqAct_Tick extends SeqAct_Latent;

var() float MyDeltaTime;
var bool Active;

event Activated()
{
	if (InputLinks[0].bHasImpulse && !Active)
	{
		Active = true;
   		ActivateOutputLink(0);
	}
	if (InputLinks[1].bHasImpulse && Active)
	{
		Active = false;
   		ActivateOutputLink(1);
	}
}

event bool Update(float DeltaTime)
{
	if (!Active) return false;

	MyDeltaTime = DeltaTime;
	ForceActivateOutput(2);
	return true;
}

defaultproperties
{
	ObjName="Kismet Tick"
	ObjCategory="Misc"
    bCallHandler=false;
    bAutoActivateOutputLinks = false;

	InputLinks(0)=(LinkDesc="Started")
	InputLinks(1)=(LinkDesc="Stopped")
	
    OutputLinks(0)=(LinkDesc="Started")
    OutputLinks(1)=(LinkDesc="Finished")
    OutputLinks(2)=(LinkDesc="Ticked")

	VariableLinks.Empty;
    VariableLinks(0)=(ExpectedType=class'SeqVar_Float', LinkDesc="OutDeltaTime", bWriteable=true, PropertyName=MyDeltaTime);
}
